chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    if (message.action === "saveFormData") {
        chrome.storage.sync.get("formData", (data) => {
            let formData = data.formData || {};
            formData[message.formId] = message.values;
            chrome.storage.sync.set({ formData }, () => {
                sendResponse({ status: "saved" });
            });
        });
        return true; // Keeps response channel open
    }
});
chrome.runtime.onMessage.addListener((request, sender) => {
    if (request.action === "fillForm") {
        chrome.tabs.sendMessage(sender.tab.id, request);
    }
});

let popupWindowId = null;

chrome.runtime.onInstalled.addListener(({ reason }) => {
    if (reason === "update" || reason === "install") {
        if (popupWindowId) {
            chrome.windows.remove(popupWindowId, () => {
                popupWindowId = null;
            });
        }
    }

    // ✅ Also close any leftover tabs that were opened by the extension
    chrome.tabs.query({}, (tabs) => {
        tabs.forEach((tab) => {
            if (tab.url.includes("popup.html")) {
                chrome.tabs.remove(tab.id);
            }
        });
    });
});



