window.addEventListener("load", () => {
    chrome.storage.sync.get("formData", (data) => {
        let storedForms = data.formData || {};
        console.log("Loaded Stored Data:", storedForms); // Debugging
        
        for (let elementId in storedForms) {
            let inputField = document.getElementById(elementId);
            if (inputField) {
                inputField.value = storedForms[elementId];
                console.log(`Auto-filled: ${elementId} -> ${storedForms[elementId]}`); // Debugging
            }
        }
    });
});

function createFloatingPanel() {
    let existingPanel = document.getElementById("autoFillPanel");
    if (existingPanel) return; 

    let panel = document.createElement("div");
    panel.id = "autoFillPanel";
    panel.style.position = "fixed";
    panel.style.bottom = "20px";
    panel.style.right = "20px";
    panel.style.background = "#fff";
    panel.style.padding = "10px";
    panel.style.border = "1px solid #ccc";
    panel.style.boxShadow = "0px 0px 5px rgba(0,0,0,0.3)";
    panel.style.zIndex = "9999";

    panel.innerHTML = "<h4>Select Form Data:</h4>";

    chrome.storage.sync.get("jsonData", (data) => {
        let entries = data.jsonData || [];

        entries.forEach((entry, index) => {
            let btn = document.createElement("button");
            btn.innerText = `Fill ${entry.title}`;
            btn.style.display = "block";
            btn.style.margin = "5px 0";
            btn.onclick = function () {
                fillForm(entry);
            };
            panel.appendChild(btn);
        });
    });

    document.body.appendChild(panel);
}

chrome.runtime.onMessage.addListener((request) => {
    if (request.action === "toggleExtension") {
        if (request.enabled) {
            createFloatingPanel();
        } else {
            let panel = document.getElementById("autoFillPanel");
            if (panel) panel.remove();
        }
    }
});
chrome.storage.sync.get("enabledSites", (data) => {
    let currentDomain = window.location.hostname;
    if (data.enabledSites && data.enabledSites[currentDomain]) {
        createFloatingPanel();
    }
});
